package gov.va.med.mhv.common.api.enumeration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum DateRangeEnum {
	CUSTOM("CUSTOM", 4L), THREEMONTHS("THREEMONTHS", 1L), SIXMONTHS("SIXMONTHS", 2L), ONEYEAR("ONEYEAR", 3L);

	private String range;
	private Long value;

	private DateRangeEnum(String range, Long value) {
		this.range = range;
		this.value = value;
	}

	public Long getValue() {
		return value;
	}

	public void setValue(Long value) {
		this.value = value;
	}

	public String getRange() {
		return range;
	}

	public void setRange(String range) {
		this.range = range;
	}

	public static List<DateRangeEnum> toList() {
		return Arrays.asList(DateRangeEnum.values());
	}

	public static DateRangeEnum valueOfByRange(String range) {
		for (DateRangeEnum e : DateRangeEnum.values()) {
			if (e.getRange().equals(range)) {
				return e;
			}
		}
		return null;
	}

	public static List<String> toRangeList() {
		List<String> rangeList = new ArrayList<String>();
		for (DateRangeEnum ft : Arrays.asList(DateRangeEnum.values())) {
			rangeList.add(ft.getRange());
		}
		return rangeList;
	}

	static public boolean isCUSTOM(DateRangeEnum range) {
		return range == CUSTOM;
	}

	static public boolean isONEYEAR(DateRangeEnum range) {
		return range == ONEYEAR;
	}

	static public boolean isSIXMONTHS(DateRangeEnum range) {
		return range == SIXMONTHS;
	}
	
	static public boolean isTHREEMONTHS(DateRangeEnum range) {
		return range == THREEMONTHS;
	}
	
}
